/*
 * QrfeProtocolHandlerGlobal.cpp
 *
 *  Created on: 22.03.2011
 *      Author: stefan.detter
 */

#include <QrfeProtocolHandlerGlobal>

static __init_QrfeProtocolHandlerGlobal	__init;


QString QrfeGlobal::tagEventToString(const QrfeGlobal::TagEvent& event)
{
	QString str;
	str += "[" + event.tagId.toHex() + "]";

	if(event.hasRSSI)
		str += " (RSSI:" + event.rssi.toHex() + ")";

	if(event.hasMemory)
		str += " (MEM: " + QString("%1, %2, ").arg(event.memBank).arg(event.memAddr) + event.memData.toHex() + ")";

	if(event.hasTrigger)
		str += " (TRIGGER: " + QString::number(event.trigger) + ")";

	if(event.hasAntenna)
		str += " (ANTENNA: " + QString::number(event.antennaId) + ")";

	if(event.hasReadFrequency)
		str += " (FREQUENCY: " + QString::number(event.readFrequency) + ")";

	if(event.hasHandle)
		str += " (HANDLE: " + event.handle.toHex() + ")";

	if(event.hasState)
		str += " (STATE: " + QString("%1").arg(event.state, 4, 16, QChar('0')) + ")";

	if(event.hasBattery)
		str += " (BATTERY: " + QString::number(event.battery) + ")";

	if(event.hasPC)
		str += " (PC: " + event.pc.toHex() + ")";

    if(event.hasRN16)
        str += " (RN16: " + event.rn16.toHex() + ")";

	if(event.hasMessageID)
		str += " (MessageID: " + QString::number(event.messageID) + ")";

    if(event.hasNxpBrandId)
        str += " (NXP-BrandID: " + event.nxpBrandId.toHex() + ")";

    return str;
}


__init_QrfeProtocolHandlerGlobal::__init_QrfeProtocolHandlerGlobal()
{
	qRegisterMetaType<QrfeGlobal::TagEvent>("QrfeGlobal::TagEvent");
}
